<!doctype html>
<html class="no-js" lang="en">

    <head>
        <title>Brands Always</title>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="author" content="ThemeZaa">
        <meta name="viewport" content="width=device-width,initial-scale=1.0" />
        <!-- favicon icon -->
        <link rel="shortcut icon" href="images/favicon.png">
        <link rel="apple-touch-icon" href="images/apple-touch-icon-57x57.png">
        <link rel="apple-touch-icon" sizes="72x72" href="images/apple-touch-icon-72x72.png">
        <link rel="apple-touch-icon" sizes="114x114" href="images/apple-touch-icon-114x114.png">
        <!-- google fonts preconnect -->
        <link rel="preconnect" href="https://fonts.googleapis.com" crossorigin>
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <!-- style sheets and font icons  -->
        <link rel="stylesheet" href="css/vendors.min.css" />
        <link rel="stylesheet" href="css/icon.min.css" />
        <link rel="stylesheet" href="css/style.min.css" />
        <link rel="stylesheet" href="css/responsive.min.css" />
        <link rel="stylesheet" href="demos/branding-agency/branding-agency.css" />
    </head>
    <body data-mobile-nav-trigger-alignment="right" data-mobile-nav-style="modern" data-mobile-nav-bg-color="#1d1d1d">
        <!-- start header -->
        <header> 
            <!-- start navigation -->
            <nav class="navbar navbar-expand-lg header-light bg-white header-reverse glass-effect">
                <div class="container-fluid">
                    <div class="col-auto col-lg-3 me-lg-0 me-auto">
                        <a class="navbar-brand" href="#">
                            <img src="images/demo-branding-agency-logo-black.png" data-at2x="images/demo-branding-agency-logo-black@2x.png" alt="" class="default-logo">
                            <img src="images/demo-branding-agency-logo-black.png" data-at2x="images/demo-branding-agency-logo-black@2x.png" alt="" class="alt-logo">
                            <img src="images/demo-branding-agency-logo-black.png" data-at2x="images/demo-branding-agency-logo-black@2x.png" alt="" class="mobile-logo"> 
                        </a>
                    </div>
                    <div class="col-auto ms-auto md-ms-0 menu-order position-static">
                        <button class="navbar-toggler float-start" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-label="Toggle navigation">
                            <span class="navbar-toggler-line"></span>
                            <span class="navbar-toggler-line"></span>
                            <span class="navbar-toggler-line"></span>
                            <span class="navbar-toggler-line"></span>
                        </button>
                        <div class="collapse navbar-collapse justify-content-center" id="navbarNav"> 
                            <ul class="navbar-nav alt-font"> 
                                <li class="nav-item"><a href="#" class="nav-link">Home</a></li>
                                <li class="nav-item"><a href="#" class="nav-link">About Us</a></li>
                                <li class="nav-item"><a href="#" class="nav-link">Contact Us</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-auto text-end d-none d-sm-flex">
                        <div class="header-icon"> 
                            <div class="header-button">
                                <a href="#" class="btn border-1 btn-transparent-light-gray btn-medium left-icon btn-switch-text">
                                    <span>
                                        <span><i class="fa-regular fa-envelope"></i></span>
                                        <span class="btn-double-text" data-text="Send a message">Send a message</span>
                                    </span>
                                </a>
                            </div>
                        </div>  
                    </div>
                </div>
            </nav>
            <!-- end navigation -->
        </header>
        <!-- end header -->
        <!-- start banner -->
        <section class="p-0 full-screen ipad-top-space-margin position-relative overflow-hidden md-h-auto">
            <div class="container-fluid p-0 h-100 position-relative">
                <div class="row h-100 g-0">
                    <div class="col-xl-5 col-lg-6 d-flex justify-content-center flex-column ps-10 xxl-ps-5 xl-ps-2 md-ps-0 position-relative order-2 order-lg-1">
                        <div class="vertical-title-center align-items-center w-75px justify-content-center position-absolute h-auto d-none d-md-flex">
                            <div class="title fs-16 alt-font text-dark-gray fw-700 text-uppercase ls-05px text-uppercase" data-fancy-text='{ "opacity": [0, 1], "translateY": [50, 0], "filter": ["blur(20px)", "blur(0px)"], "string": ["Branded Fashion Solutions for Smart Retailers"], "duration": 400, "delay": 0, "speed": 50, "easing": "easeOutQuad" }'></div>
                        </div>
                        <div class="border-start border-color-extra-medium-gray ps-60px ms-100px lg-ps-30px lg-ms-70px position-relative z-index-9 sm-ps-30px sm-pe-30px sm-ms-0 border-0" data-anime='{ "el": "childs", "translateY": [30, 0], "opacity": [0,1], "duration": 600, "delay":0, "staggervalue": 300, "easing": "easeOutQuad" }'>
                            <h1 class="text-dark-gray fw-600 alt-font outside-box-right-10 xl-outside-box-right-15 ls-minus-4px sm-ls-minus-2px md-me-0">Build Your Future with Brands Always</h1>
                            <p class="w-75 mb-35px lg-w-90 sm-w-100">Step into a thriving retail ecosystem built for success.</p>
                            <a href="#" class="btn btn-extra-large btn-gradient-fuel-yellow-blue fw-400">Let's talk - Send a message</a>
                        </div>
                    </div>
                    <div class="col-xl-7 col-lg-6 position-relative swiper-number-pagination-progress md-h-500px order-1 order-lg-2 md-mb-50px"> 
                        <div class="swiper h-100 banner-slider magic-cursor drag-cursor" data-slider-options='{ "slidesPerView": 1, "loop": true, "pagination": { "el": ".swiper-number-line-pagination", "clickable": true }, "navigation": { "nextEl": ".slider-one-slide-next-1", "prevEl": ".slider-one-slide-prev-1" }, "autoplay": { "delay": 4000, "stopOnLastSlide": true, "disableOnInteraction": false },"keyboard": { "enabled": true, "onlyInViewport": true }, "effect": "fade" }' data-swiper-number-pagination-progress="true">
                            <div class="swiper-wrapper">
                                <!-- start slider item -->
                                <div class="swiper-slide">
                                    <div class="position-absolute left-0px top-0px w-100 h-100 cover-background background-position-center-top" style="background-image:url('images/demo-branding-agency-slider-01.jpg');"></div>
                                </div>
                                <!-- end slider item -->
                                <!-- start slider item -->
                                <div class="swiper-slide">
                                    <div class="position-absolute left-0px top-0px w-100 h-100 cover-background background-position-center-top" style="background-image:url('images/demo-branding-agency-slider-02.jpg');"></div>
                                </div>
                                <!-- end slider item -->
                                <!-- start slider item -->
                                <div class="swiper-slide">
                                    <div class="position-absolute left-0px top-0px w-100 h-100 cover-background background-position-center-top" style="background-image:url('images/demo-branding-agency-slider-03.jpg');"></div>
                                </div>
                                <!-- end slider item -->  
                            </div>
                            <!-- start slider pagination -->
                            <div  class="swiper-pagination swiper-pagination-clickable swiper-pagination-bullets d-block d-sm-none"></div>
                            <!-- end slider pagination --> 
                            <!-- start slider navigation -->
                            <!-- <div class="slider-one-slide-prev-1 icon-very-small text-white swiper-button-prev slider-navigation-style-06 d-none d-sm-inline-block"><i class="line-icon-Arrow-OutLeft icon-extra-large"></i></div>
                                <div class="slider-one-slide-next-1 icon-very-small text-white swiper-button-next slider-navigation-style-06 d-none d-sm-inline-block"><i class="line-icon-Arrow-OutRight icon-extra-large"></i></div> -->
                            <!-- end slider navigation -->
                        </div>
                        <!-- start slider pagination -->
                        <div class="swiper-pagination-wrapper d-none d-lg-flex align-items-center justify-content-center position-absolute bottom-40px md-bottom-30px sm-bottom-20px left-minus-45 md-left-30px sm-left-20px z-index-9">
                            <div class="number-prev fs-14 fw-600 text-dark-gray"></div>
                            <div class="swiper-pagination-progress bg-extra-medium-gray">
                                <span class="swiper-progress"></span>
                            </div>
                            <div class="number-next fs-14 fw-600 text-dark-gray"></div>    
                        </div>
                        <!-- end slider pagination -->
                    </div>
                </div>
            </div>
        </section>
        <!-- end banner --> 
       
        <!-- end section -->
        <!-- start section -->
        <section class="pt-0 mt-6">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 position-relative">
                        <div class="row align-items-center position-relative md-mb-15" data-anime='{ "opacity": [0,1], "duration": 600, "delay":0, "staggervalue": 300, "easing": "easeOutQuad" }'>
                            <div class="col-md-5 sm-mb-30px" data-bottom-top="transform: translateY(50px)" data-top-bottom="transform: translateY(-50px)">
                                <img class="w-100" src="images/demo-branding-agency-home-01.jpg" alt="" />
                            </div>
                            <div class="col-lg-7 col-md-7 sm-mb-30px text-end" data-bottom-top="transform: translateY(-30px)" data-top-bottom="transform: translateY(30px)">
                                <img src="images/demo-branding-agency-home-03.jpg" alt="" class="box-shadow-quadruple-large md-w-100" />
                            </div>
                            <div class="w-50 sm-w-100 overflow-hidden position-absolute sm-position-relative left-140px bottom-minus-200px sm-bottom-0px sm-left-0px p-0 sm-ps-15px sm-pe-15px" data-shadow-animation="true" data-animation-delay="100" data-bottom-top="transform: translateY(20px)" data-top-bottom="transform: translateY(-20px)">
                                <img src="images/demo-branding-agency-home-02.jpg" alt="" class="box-shadow-quadruple-large w-100" />
                            </div>
                        </div> 
                    </div>
                    <div class="col-xl-6 col-lg-6  md-mt-20 sm-mt-0" data-anime='{ "el": "childs", "translateY": [30, 0], "opacity": [0,1], "duration": 600, "delay":0, "staggervalue": 300, "easing": "easeOutQuad" }'>
                        <div class="mb-10px">
                            <span class="w-25px h-1px d-inline-block bg-base-color me-5px align-middle"></span>
                            <span class="text-blue fs-15 alt-font fw-700 ls-05px text-uppercase d-inline-block align-middle">About Brand Always</span>
                        </div>
                        <h4 class="text-dark-gray alt-font fw-600 ls-minus-2px mb-20px">We provide brilliant ideas and adding the world called success to your brand.</h4>
                        <p class="md-w-100 mb-35px sm-mb-20px text-align">Brands Always is a one-of-a-kind retail concept offering genuine, imported branded apparel,
 sportswear, footwear, and accessories for men, women, and kids at unbeatable discounts. With a
 former CEO/President of an international brand heading procurement, and another Founder Partner
 with over a decade of experience in franchise business with leading national brands in India, we
 ensure 100% authenticity, premium quality, and a strong, scalable business model. Our stores
 provide customers with globally sourced products at 50-60% off MRP, making high-end fashion and
 sportswear more accessible. We are looking for enthusiastic partners to expand our brand across
 key markets through our franchise model</p>
                        <a href="#" class="btn btn-large btn-dark-gray btn-switch-text btn-box-shadow border-1 left-icon me-10px sm-mb-15px sm-mt-15px">
                            <span>
                                <span><i class="feather icon-feather-edit"></i></span>
                                <span class="btn-double-text" data-text="Explore details">Explore details</span> 
                            </span>
                        </a> 
                        <!-- <a href="#" class="btn btn-large btn-transparent-light-gray border-1 btn-switch-text left-icon sm-mb-15px sm-mt-15px">
                            <span>
                                <span><i class="feather icon-feather-briefcase"></i></span>
                                <span class="btn-double-text" data-text="More services">More services</span> 
                            </span>
                        </a> -->
                    </div>
                </div>
            </div>
        </section>
        <!-- end section -->
        <!-- start section -->
        <section class="pt-0 border-top border-color-extra-medium-gray mt-6 md-mt-0 sm-border-top-0">
            <div class="container">
                <div class="row row-cols-1 row-cols-md-3 row-cols-sm-2 g-0" data-anime='{ "el": "childs", "translateX": [30, 0], "opacity": [0,1], "duration": 600, "delay":0, "staggervalue": 300, "easing": "easeOutQuad" }'>
                    <!-- start process step item -->
                    <div class="col process-step-style-06 last-paragraph-no-margin hover-box sm-mb-50px">
                        <div class="process-step-icon-box position-relative top-minus-14px">
                            <span class="progress-step-separator bg-light-gray w-100 separator-line-1px opacity-1"></span>
                            <div class="step-box d-flex align-items-center justify-content-center bg-white border-radius-100 w-25px h-25px position-relative border border-color-extra-medium-gray box-shadow-large">
                                <span class="w-7px h-7px bg-whitecolor border-radius-100"></span>
                            </div>
                        </div>
                        <span class="d-block alt-font text-dark-gray fw-600 mb-10px mt-15px fs-22 lh-28 ls-minus-05px w-80 lg-w-75 md-w-100">150+ Successful Franchise Outlets</span>
                        <p class="w-80 lg-w-75 md-w-100 sm-w-100">Our strong and growing network of franchise stores spans across India, built on a profitable, scalable business model.</p>
                    </div>
                    <!-- end process step item -->
                    <!-- start process step item -->
                    <div class="col process-step-style-06 last-paragraph-no-margin hover-box sm-mb-50px">
                        <div class="process-step-icon-box position-relative top-minus-14px">
                            <span class="progress-step-separator bg-light-gray w-100 separator-line-1px opacity-1"></span>
                            <div class="step-box d-flex align-items-center justify-content-center bg-white border-radius-100 w-25px h-25px position-relative border border-color-extra-medium-gray box-shadow-large">
                                <span class="w-7px h-7px bg-whitecolor border-radius-100"></span>
                            </div>
                        </div>
                        <span class="d-block alt-font text-dark-gray fw-600 mb-10px mt-15px fs-22 lh-28 ls-minus-05px w-80 lg-w-75 md-w-100">75+ Global & National Brand Tie-ups</span>
                        <p class="w-80 lg-w-75 md-w-100 sm-w-100">Our shelves are stocked with authentic products from top international and Indian brands, carefully curated by industry experts.</p>
                    </div>
                    <!-- end process step item -->
                    <!-- start process step item -->
                    <div class="col process-step-style-06 last-paragraph-no-margin hover-box">
                        <div class="process-step-icon-box position-relative top-minus-14px">
                            <span class="progress-step-separator bg-light-gray w-100 separator-line-1px opacity-1"></span>
                            <div class="step-box d-flex align-items-center justify-content-center bg-white border-radius-100 w-25px h-25px position-relative border border-color-extra-medium-gray box-shadow-large">
                                <span class="w-7px h-7px bg-whitecolor border-radius-100"></span>
                            </div>
                        </div>
                        <span class="d-block alt-font text-dark-gray fw-600 mb-10px mt-15px fs-22 lh-28 ls-minus-05px w-80 lg-w-75 md-w-100">100% Authentic Products, Always</span>
                        <p class="w-80 lg-w-75 md-w-100 sm-w-100">Led by former executives of global brands, our procurement ensures every item is genuine, branded, and premium in quality.</p>
                    </div>
                    <!-- end process step item --> 
                </div>
            </div>
        </section>
        <!-- end section -->
        <!-- start section -->
        <section class="overflow-hidden position-relative pt-0 lg-pb-0">
            <div class="container-fluid">
                <div class="row position-relative">
                    <div class="col swiper swiper-width-auto feather-shadow text-center" data-slider-options='{ "slidesPerView": "auto", "spaceBetween":40, "speed": 20000, "loop": true, "allowTouchMove": false, "autoplay": { "delay":0, "disableOnInteraction": false, "reverseDirection": true }, "effect": "slide" }'>
                        <div class="swiper-wrapper pb-30px marquee-slide">
                            <!-- start client item -->
                            <div class="swiper-slide">
                                <div class="fs-130 md-fs-90 sm-fs-70 alt-font text-dark-gray fw-600 ls-minus-6px sm-ls-minus-2px word-break-normal">Franchise the Future of Fashion <span class="ms-20px">-</span></div>
                            </div>
                            <!-- end client item -->    
                            <!-- start client item -->
                            <div class="swiper-slide">
                                <div class="fs-130 md-fs-90 sm-fs-70 alt-font text-dark-gray fw-600 ls-minus-6px sm-ls-minus-2px word-break-normal">Premium Brands. Proven Profits. <span class="ms-20px">-</span></div>
                            </div>
                            <!-- end client item --> 
                        </div> 
                    </div>  
                </div>
            </div> 
        </section>
        <!-- end section -->
        <!-- start section -->  
        <section class="stack-box py-0 z-index-99"> 
            <div class="stack-box-contain">
                <!-- start stack item -->
                <div class="stack-item stack-item-01 bg-white lg-pt-8 lg-pb-8 md-pb-0">
                    <div class="stack-item-wrapper">
                        <div class="container-fluid">
                            <div class="row align-items-center full-screen md-h-auto"> 
                                <div class="col-lg-6 cover-background overflow-visible h-100 md-h-500px" style="background-image: url(images/demo-branding-agency-home-04.jpg)">
                                    <div class="position-absolute right-minus-130px top-60px md-top-auto md-bottom-minus-50px fs-170 lg-fs-120 lg-right-minus-80px md-right-0px md-left-0px text-center text-lg-start alt-font z-index-9 fw-600 text-white opacity-3">01</div>
                                    <div class="position-absolute right-0px bottom-minus-1px">
                                        <div class="vertical-title-center">
                                            <div class="title fw-700 fs-15 alt-font text-uppercase text-white bg-white pt-30px pb-30px ps-10px pe-10px">
                                                <span class="d-inline-block">Requirements at a Glance</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 ps-12 pe-14 xxl-ps-10 xxl-pe-10 xl-pe-8 lg-ps-6 lg-pe-4 md-p-50px sm-ps-30px sm-pe-30px position-relative align-self-center text-md-start text-center"> 
                                    <div class="mb-15px">
                                        <span class="w-25px h-1px d-inline-block bg-base-color me-5px align-middle"></span>
                                        <span class="text-white fs-15 alt-font fw-700 ls-05px text-uppercase d-inline-block align-middle"> Franchise Requirements</span>
                                    </div>
                                    <h3 class="text-white alt-font fw-600 ls-minus-4px mb-25px">What It Takes to Partner with Us</h3>
                                    <h4 class="fs-20 fw-600 text-white mb-5px">1. Store Location & Size</h4>
                                    <p class="w-95 md-w-100 mb-15px text-white">- Minimum 1,500 - 2,000 sq. ft. in high footfall areas such as malls, shopping streets, or commercial hubs.</p>
                                    
                                    <h4 class="fs-20 fw-600 text-white mb-5px">2. Investment Details</h4>
                                    <p class="w-95 md-w-100 mb-15px text-white">A. Setup Cost</p>
                                    <p class="w-95 md-w-100 mb-15px text-white">B. Stock Investment</p>
                                    <p class="w-95 md-w-100 mb-15px text-white">C. Additional Costs</p>
                                    
                                    
                                    
                                    <a href="#" class="btn btn-large btn-dark-gray btn-switch-text btn-box-shadow fw-400">
                                        <span> 
                                            <span class="btn-double-text" data-text="Learn More">Learn More</span> 
                                            <span><i class="feather icon-feather-arrow-right"></i></span>
                                        </span>
                                    </a>  
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end stack item -->
                <!-- start stack item -->
                <div class="stack-item stack-item-02 bg-linen md-pt-0 md-pb-0">
                    <div class="stack-item-wrapper">
                        <div class="container-fluid">
                            <div class="row align-items-center full-screen md-h-auto">  
                                <div class="col-lg-6 cover-background overflow-visible h-100 md-h-500px" style="background-image: url(images/demo-branding-agency-home-05.jpg)">
                                    <div class="position-absolute right-minus-130px top-60px md-top-auto md-bottom-minus-50px fs-170 lg-fs-120 lg-right-minus-80px md-right-0px md-left-0px text-center text-lg-start alt-font z-index-9 fw-600 text-dark-gray opacity-3">02</div>
                                    <div class="position-absolute right-0px bottom-minus-1px">
                                        <div class="vertical-title-center">
                                            <div class="title fw-700 fs-15 alt-font text-uppercase text-dark-gray bg-linen pt-30px pb-30px ps-10px pe-10px">
                                                <span class="d-inline-block">Profits That Scale</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 ps-12 pe-14 xxl-ps-10 xxl-pe-10 xl-pe-8 lg-ps-6 lg-pe-4 md-p-50px sm-ps-30px sm-pe-30px position-relative align-self-center text-md-start text-center"> 
                                    <div class="mb-15px">
                                        <span class="w-25px h-1px d-inline-block bg-base-color me-5px align-middle"></span>
                                        <span class="text-blue fs-15 alt-font fw-700 ls-05px text-uppercase d-inline-block align-middle">Revenue Model & Profitability</span>
                                    </div>
                                    <h3 class="text-dark-gray alt-font fw-600 ls-minus-4px mb-25px">Smart Returns, Sustainable Growth</h3>
                                    <ul>
                                        <li>- Selling Price to Customers: 50-60% off MRP.</li>
                                        <li>- Franchisee Margin: 40-45% (inclusive of GST)</li>
                                        <li>- Fast-Moving Inventory: Ensuring quick turnover and regular replenishment of new stock.</li>
                                        <li>- Projected Sales: Rs.15 - 20 lakh per month.</li>
                                        <li>- Break-even timeline: 24 to 36 months.</li>
                                    </ul>
                                    <!-- <p class="w-95 md-w-100 mb-35px">We specialize in developing products with a distinct and compelling identity. Our team excels generating brilliant ideas that propel brands to success. Through customized marketing campaigns.</p> -->
                                    <a href="#" class="btn btn-large btn-dark-gray btn-switch-text btn-box-shadow fw-400">
                                        <span> 
                                            <span class="btn-double-text" data-text="Learn More">Learn More</span> 
                                            <span><i class="feather icon-feather-arrow-right"></i></span>
                                        </span>
                                    </a>  
                                </div>
                            </div> 
                        </div>
                    </div>
                </div>
                <!-- end stack item -->
                <!-- start stack item -->
                <div class="stack-item stack-item-03 bg-white lg-pt-8 md-pb-0 md-pt-0">
                    <div class="stack-item-wrapper">
                        <div class="container-fluid">
                            <div class="row align-items-center full-screen md-h-auto"> 
                                <div class="col-lg-6 cover-background overflow-visible h-100 md-h-500px" style="background-image: url(images/demo-branding-agency-home-06.jpg)">
                                    <div class="position-absolute right-minus-130px top-60px md-top-auto md-bottom-minus-50px fs-170 lg-fs-120 lg-right-minus-80px md-right-0px md-left-0px text-center text-lg-start alt-font z-index-9 fw-600 text-white opacity-3">03</div>
                                    <div class="position-absolute right-0px bottom-minus-1px">
                                        <div class="vertical-title-center">
                                            <div class="title fw-700 fs-15 alt-font text-uppercase text-white bg-white pt-30px pb-30px ps-10px pe-10px">
                                                <span class="d-inline-block">Stronger Together</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 ps-12 pe-14 xxl-ps-10 xxl-pe-10 xl-pe-8 lg-ps-6 lg-pe-4 md-p-50px sm-ps-30px sm-pe-30px sm-pb-0 position-relative align-self-center text-md-start text-center"> 
                                    <div class="mb-15px">
                                        <span class="w-25px h-1px d-inline-block bg-base-color me-5px align-middle"></span>
                                        <span class="text-white fs-15 alt-font fw-700 ls-05px text-uppercase d-inline-block align-middle">Franchise Support & Benefits</span>
                                    </div>
                                    <h3 class="text-white alt-font fw-600 ls-minus-4px mb-25px">Support That Drives Growth</h3>
                                    <ul class="text-white">
                                        <li>- Branding & Store Setup Assistance.</li>
                                        <li>- Product Supply & Inventory Planning.</li>
                                        <li>- Training & Operations Support.
                                            <ul>
                                                <li>- Staff training on customer service and sales techniques.</li>
                                                <li>- Billing and inventory management system guidance.</li>
                                            </ul>
                                        </li>
                                        <li>- Marketing & Promotions.</li>
                                        <li>- Ongoing Business Support.</li>
                                    </ul>
                                    
                                    <!-- <p class="w-95 md-w-100 mb-35px">Creating products with a strong identity. Provide brilliant ideas and adding the world called success brand. We deliver customized marketing campaign to use your audience to make a positive move.</p> -->
                                    <a href="#" class="btn btn-large btn-dark-gray btn-switch-text btn-box-shadow fw-400">
                                        <span> 
                                            <span class="btn-double-text" data-text="Learn More">Learn More</span> 
                                            <span><i class="feather icon-feather-arrow-right"></i></span>
                                        </span>
                                    </a>  
                                </div>
                            </div>
                        </div>
                    </div>  
                </div>
                <!-- end stack item -->
            </div>
        </section>
        <!-- end section -->  
        <!-- start section -->
        <section class="pb-0">
            <div class="container">
                <div class="row mb-6">
                    <div class="col-xl-5 col-md-6" data-anime='{ "el": "childs", "translateY": [30, 0], "opacity": [0,1], "duration": 600, "delay":0, "staggervalue": 300, "easing": "easeOutQuad" }'>
                        <div class="mb-10px">
                            <span class="w-25px h-1px d-inline-block bg-base-color me-5px align-middle"></span>
                            <span class="text-blue fs-15 alt-font fw-700 ls-05px text-uppercase d-inline-block align-middle">Why Choose Us</span>
                        </div>
                        <h4 class="text-dark-gray alt-font fw-600 w-90 ls-minus-2px">Why Partner with 'Brands Always'</h4>
                    </div>
                    <div class="offset-xl-1 col-xl-5 col-md-6">
                        <div class="accordion accordion-style-02" id="accordion-style-02" data-active-icon="icon-feather-minus" data-inactive-icon="icon-feather-plus" data-anime='{ "el": "childs", "translateY": [30, 0], "opacity": [0,1], "duration": 600, "delay":0, "staggervalue": 300, "easing": "easeOutQuad" }'>
                            <!-- start accordion item -->
                            <div class="accordion-item active-accordion">
                                <div class="accordion-header border-bottom border-color-dark-gray">
                                    <a href="#" data-bs-toggle="collapse" data-bs-target="#accordion-style-02-01" aria-expanded="true" data-bs-parent="#accordion-style-02">
                                        <div class="accordion-title mb-0 position-relative text-dark-gray">
                                            <i class="feather icon-feather-minus"></i><span class="fw-600 alt-font fs-18">Unique Retail Concept</span>
                                        </div>
                                    </a>
                                </div>
                                <div id="accordion-style-02-01" class="accordion-collapse collapse show" data-bs-parent="#accordion-style-02">
                                    <div class="accordion-body last-paragraph-no-margin border-bottom border-color-dark-gray">
                                        <p>A one-of-a-kind model offering genuine, imported branded fashion and sportswear at unbeatable discounts, creating high consumer demand.</p>
                                    </div>
                                </div>
                            </div>
                            <!-- end accordion item -->
                            <!-- start accordion item -->
                            <div class="accordion-item">
                                <div class="accordion-header border-bottom border-color-dark-gray">
                                    <a href="#" data-bs-toggle="collapse" data-bs-target="#accordion-style-02-02" aria-expanded="false" data-bs-parent="#accordion-style-02">
                                        <div class="accordion-title mb-0 position-relative text-dark-gray">
                                            <i class="feather icon-feather-plus"></i><span class="fw-600 alt-font fs-18">Proven Franchise Model</span>
                                        </div>
                                    </a>
                                </div>
                                <div id="accordion-style-02-02" class="accordion-collapse collapse" data-bs-parent="#accordion-style-02">
                                    <div class="accordion-body last-paragraph-no-margin border-bottom border-color-dark-gray">
                                        <p>Built by industry veterans with a history of successful brand and franchise operations, ensuring strong ROI and business scalability.</p>
                                    </div>
                                </div>
                            </div>
                            <!-- end accordion item -->
                            <!-- start accordion item -->
                            <div class="accordion-item">
                                <div class="accordion-header border-bottom border-color-transparent">
                                    <a href="#" data-bs-toggle="collapse" data-bs-target="#accordion-style-02-03" aria-expanded="false" data-bs-parent="#accordion-style-02">
                                        <div class="accordion-title mb-0 position-relative text-dark-gray">
                                            <i class="feather icon-feather-plus"></i><span class="fw-600 alt-font fs-18"> Premium Global Brands</span>
                                        </div>
                                    </a>
                                </div>
                                <div id="accordion-style-02-03" class="accordion-collapse collapse" data-bs-parent="#accordion-style-02">
                                    <div class="accordion-body last-paragraph-no-margin border-bottom border-color-transparent">
                                        <p>Access to a curated portfolio of top international and national brands, ensuring product appeal and customer trust.</p>
                                    </div>
                                </div>
                            </div>
                            <!-- end accordion item -->
                        </div>
                    </div>
                </div>
                <div class="row row-cols-1 row-cols-lg-4 row-cols-md-2 counter-style-04" data-anime='{ "el": "childs", "translateX": [30, 0], "opacity": [0,1], "duration": 600, "delay":0, "staggervalue": 300, "easing": "easeOutQuad" }'>
                    <!-- start counter item -->
                    <div class="col last-paragraph-no-margin md-mb-30px text-center text-md-start">
                        <span class="alt-font fw-600 d-block mb-5px text-dark-gray fs-18">Assured Authenticity</span>
                        <p class="w-100 sm-w-100 sm-ps-15 sm-pe-15">Every product is a genuine, globally imported brand item.</p>
                        <div class="separator-line-1px bg-extra-medium-gray w-90 mt-25px mb-25px sm-w-100"></div>
                        <h3 class="vertical-counter d-inline-flex alt-font text-dark-gray fw-700 ls-minus-2px sm-ls-minus-1px sm-mb-0" data-text="%" data-to="100"></h3> Original
                    </div>
                    <!-- end counter item -->
                    <!-- start counter item -->
                    <div class="col last-paragraph-no-margin md-mb-30px text-center text-md-start">
                        <span class="alt-font fw-600 d-block mb-5px text-dark-gray fs-18">Franchise Expertise</span>
                        <p class="w-100 sm-w-100 sm-ps-15 sm-pe-15">Led by industry veterans, ensuring the best brands and pricing.</p>
                        <div class="separator-line-1px bg-extra-medium-gray w-90 mt-25px mb-25px sm-w-100"></div>
                        <h3 class="vertical-counter d-inline-flex alt-font text-dark-gray fw-700 ls-minus-2px sm-ls-minus-1px sm-mb-0" data-text="+" data-to="20"></h3>  Years of Experience 
                    </div>
                    <!-- end counter item -->
                    <!-- start counter item -->
                    <div class="col last-paragraph-no-margin sm-mb-30px text-center text-md-start">
                        <span class="alt-font fw-600 d-block mb-5px text-dark-gray fs-18">Attractive Customer Pricing</span>
                        <p class="w-100 sm-w-100 sm-ps-15 sm-pe-15">Premium fashion at 50–60% off MRP, driving footfall and loyalty.</p>
                        <div class="separator-line-1px bg-extra-medium-gray w-90 mt-25px mb-25px sm-w-100"></div>Up to
                        <h3 class="vertical-counter d-inline-flex alt-font text-dark-gray fw-700 ls-minus-2px sm-ls-minus-1px sm-mb-0" data-text="%" data-to="60"> </h3> Off 
                    </div>
                    <!-- end counter item -->
                    <!-- start counter item -->
                    <div class="col last-paragraph-no-margin text-center text-md-start">
                        <span class="alt-font fw-600 d-block mb-5px text-dark-gray fs-18">High Profit Margins</span>
                        <p class="w-100 sm-w-100 sm-ps-15 sm-pe-15">Franchise partners earn 40–45% margins on every sale.</p>
                        <div class="separator-line-1px bg-extra-medium-gray w-90 mt-25px mb-25px sm-w-100"></div>
                        <h3 class="vertical-counter d-inline-flex alt-font text-dark-gray fw-700 ls-minus-2px sm-ls-minus-1px sm-mb-0" data-text="%" data-to="45"></h3> Margin
                    </div>
                    <!-- end counter item -->
                </div>
            </div>
        </section>
        <!-- end section -->
        <!-- start section -->
        <section class="pb-0">
            <div class="container-fluid p-0">
                <div class="row row-cols-1 row-cols-lg-4 row-cols-sm-2 g-0" data-anime='{ "el": "childs", "translateY": [30, 0], "rotateX":[30, 0], "opacity": [0,1], "duration": 600, "delay":0, "staggervalue": 300, "easing": "easeOutQuad" }'>
                    <!-- start team member item --> 
                    <div class="col team-style-10 md-ps-15px md-pe-15px md-mb-30px">
                        <figure class="mb-0 position-relative overflow-hidden">
                            <img src="images/brand1.jpg" class="w-100" alt="" />
                            <img src="images/brand11.jpg" class="hover-switch-image" alt="" />
                            <figcaption class="w-100 h-100 d-flex flex-wrap">
                                <!-- <div class="social-icon d-flex flex-column flex-shrink-1 mb-auto p-30px ms-auto">
                                    <a href="https://www.twitter.com/" target="_blank" class="text-white bg-dark-gray"><i class="fa-brands fa-twitter icon-small"></i></a>
                                </div> -->
                                <div class="team-member-strip w-100 mt-auto d-flex align-items-center pt-15px pb-15px ps-30px pe-30px bg-white">
                                    <span class="team-member-name fw-600 alt-font text-dark-gray fs-18 ls-minus-05px">Puma</span>
                                    <!-- <span class="member-designation fs-15 lh-20 ms-auto alt-font">Designer</span> -->
                                </div> 
                            </figcaption>
                        </figure>
                    </div>
                    <!-- end team member item -->
                    <!-- start team member item --> 
                    <div class="col team-style-10 mt-20px md-mt-0 md-ps-15px md-pe-15px md-mb-30px">
                        <figure class="mb-0 position-relative overflow-hidden">
                            <img src="images/brand21.jpg" class="w-100" alt="" />
                            <img src="images/brand2.jpg" class="hover-switch-image" alt="" />
                            <figcaption class="w-100 h-100 d-flex flex-wrap">
                                <!-- <div class="social-icon d-flex flex-column flex-shrink-1 mb-auto p-30px ms-auto">
                                    <a href="https://www.facebook.com/" target="_blank" class="text-white bg-dark-gray"><i class="fa-brands fa-facebook-f icon-small"></i></a>
                                </div> -->
                                <div class="team-member-strip w-100 mt-auto d-flex align-items-center pt-15px pb-15px ps-30px pe-30px bg-white">
                                    <span class="team-member-name fw-600 alt-font text-dark-gray fs-18 ls-minus-05px">champion </span>
                                    <!-- <span class="member-designation fs-15 lh-20 ms-auto alt-font">Writer</span> -->
                                </div> 
                            </figcaption>
                        </figure>
                    </div>
                    <!-- end team member item -->
                    <!-- start team member item --> 
                    <div class="col team-style-10 mt-40px md-mt-0 md-ps-15px md-pe-15px sm-mb-30px">
                        <figure class="mb-0 position-relative overflow-hidden">
                            <img src="images/brand3.png" class="w-100" alt="" />
                            <img src="images/brand31.jpg" class="hover-switch-image" alt="" />
                            <figcaption class="w-100 h-100 d-flex flex-wrap">
                                <!-- <div class="social-icon d-flex flex-column flex-shrink-1 mb-auto p-30px ms-auto">
                                    <a href="https://www.linkedin.com/" target="_blank" class="text-white bg-dark-gray"><i class="fa-brands fa-linkedin-in icon-small"></i></a>
                                </div> -->
                                <div class="team-member-strip w-100 mt-auto d-flex align-items-center pt-15px pb-15px ps-30px pe-30px bg-white">
                                    <span class="team-member-name fw-600 alt-font text-dark-gray fs-18 ls-minus-05px">Skechers </span>
                                    <!-- <span class="member-designation fs-15 lh-20 ms-auto alt-font">Manager</span> -->
                                </div> 
                            </figcaption>
                        </figure>
                    </div>
                    <!-- end team member item -->
                    <!-- start team member item --> 
                    <div class="col team-style-10 mt-60px md-mt-0 md-ps-15px md-pe-15px">
                        <figure class="mb-0 position-relative overflow-hidden">
                            <img src="images/brand4.jpg" class="w-100" alt="" />
                            <img src="images/brand41.jpg" class="hover-switch-image" alt="" />
                            <figcaption class="w-100 h-100 d-flex flex-wrap">
                                <!-- <div class="social-icon d-flex flex-column flex-shrink-1 mb-auto p-30px ms-auto">
                                    <a href="https://www.instagram.com/" target="_blank" class="text-white bg-dark-gray"><i class="fa-brands fa-instagram icon-small"></i></a>
                                </div> -->
                                <div class="team-member-strip w-100 mt-auto d-flex align-items-center pt-15px pb-15px ps-30px pe-30px bg-white">
                                    <span class="team-member-name fw-600 alt-font text-dark-gray fs-18 ls-minus-05px">Adidas</span>
                                    <!-- <span class="member-designation fs-15 lh-20 ms-auto alt-font">Designer</span> -->
                                </div> 
                            </figcaption>
                        </figure>
                    </div>
                    <!-- end team member item -->
                </div>
            </div>
        </section>
        <!-- end section -->
        <!-- start section -->
        <section class="big-section position-relative"> 
            <div class="background-position-center-top background-no-repeat position-absolute h-100 w-100 left-0px top-0px" style="background-image: url('images/demo-branding-agency-bg-01.png')"></div>
            <div class="container position-relative">
                <div class="row justify-content-center mb-8" data-anime='{ "opacity": [0,1], "duration": 600, "delay":0, "staggervalue": 300, "easing": "easeOutQuad" }'>
                    <div class="col-xl-4 col-md-5">
                        <h2 class="alt-font text-dark-gray mb-30px fw-600 ls-minus-3px">We are trusted by our clients<i class="bi bi-heart-fill d-inline-block align-top ms-10px animation-zoom icon-very-medium text-red"></i></h2>
                        <div class="d-flex md-mb-25px">
                            <!-- start slider navigation -->
                            <div class="slider-one-slide-prev-1 text-white swiper-button-prev slider-navigation-style-04 border border-1 border-color-extra-medium-gray bg-white"><i class="fa-solid fa-arrow-left"></i></div>
                            <div class="slider-one-slide-next-1 text-white swiper-button-next slider-navigation-style-04 border border-1 border-color-extra-medium-gray bg-white"><i class="fa-solid fa-arrow-right"></i></div>
                            <!-- end slider navigation -->
                        </div>
                    </div>
                    <div class="col-xl-6 col-md-7 overflow-hidden offset-xl-2"> 
                        <div class="swiper" data-slider-options='{ "slidesPerView": 1, "spaceBetween": 40, "loop": true, "autoplay": { "delay": 8000, "disableOnInteraction": false }, "navigation": { "nextEl": ".slider-one-slide-next-1", "prevEl": ".slider-one-slide-prev-1" }, "keyboard": { "enabled": true, "onlyInViewport": true }, "breakpoints": { "992": { "slidesPerView": 1 }, "768": { "slidesPerView":1 }, "320": { "slidesPerView": 1 } }, "effect": "slide" }'>
                            <div class="swiper-wrapper"> 
                                <!-- start review item -->
                                <div class="swiper-slide">
                                    <h5 class="text-dark-gray mb-15px w-95 xl-w-100 lh-40 ls-minus-1px alt-font">"Partnering with Brands Always has been the best business decision I’ve made. The support is incredible, and the product range practically sells itself."</h5>
                                    <span class="text-blue fw-700 text-uppercase ls-1px">Ramesh M</span> 
                                </div>
                                <!-- end review item -->
                                <!-- start review item -->
                                <div class="swiper-slide">
                                    <h5 class="text-dark-gray mb-15px w-95 xl-w-100 lh-40 ls-minus-1px alt-font">"From setup to operations, everything was seamless. Customers love the prices, and I love the margins!"</h5>
                                    <span class="text-blue fw-700 text-uppercase ls-1px">Neha S</span> 
                                </div>
                                <!-- end review item -->
                                <!-- start review item -->
                                <div class="swiper-slide">
                                    <h5 class="text-dark-gray mb-15px w-95 xl-w-100 lh-40 ls-minus-1px alt-font">"The authenticity of the products and the professional approach of the team made me confident from day one. I’ve already opened a second outlet!"</h5>
                                    <span class="text-blue fw-700 text-uppercase ls-1px"> Arvind K</span> 
                                </div>
                                <!-- end review item -->
                            </div>  
                        </div> 
                    </div>
                </div> 
                <div class="row row-cols-1 row-cols-lg-5 row-cols-md-3 row-cols-sm-2 clients-style-06 justify-content-center" data-anime='{ "el": "childs", "translateY": [30, 0], "opacity": [0,1], "skewX":[20, 0], "duration": 300, "delay":0, "staggervalue": 200, "easing": "easeOutQuad" }'>
                    <!-- start client item -->
                    <div class="col client-box text-center md-mb-35px">
                        <a href="#"><img src="images/5.png" class="h-100px" alt=""></a>
                    </div>
                    <!-- end client item -->
                    <!-- start client item -->
                    <div class="col client-box text-center md-mb-35px">
                        <a href="#"><img src="images/3.png" class="h-100px" alt=""></a>
                    </div>
                    <!-- end client item -->
                    <!-- start client item -->
                    <div class="col client-box text-center md-mb-35px">
                        <a href="#"><img src="images/2.jpg" class="h-100px" alt=""></a>
                    </div>
                    <!-- end client item -->
                    <!-- start client item -->
                    <div class="col client-box text-center sm-mb-35px">
                        <a href="#"><img src="images/4.png" class="h-100px" alt=""></a>
                    </div> 
                    <!-- end client item -->
                    <!-- start client item -->
                    <div class="col client-box text-center">
                        <a href="#"><img src="images/6.png" class="h-100px" alt=""></a>
                    </div> 
                    <!-- end client item -->
                </div>
            </div>
        </section>
        <!-- end section -->
        <!-- start footer -->
        <footer class="bg-charcoal-blue pb-4 sm-pb-50px" style="background-image: url(images/demo-branding-agency-pattern.svg)">
            <div class="container">
                <div class="row mb-6">
                    <div class="col-lg-5 col-md-6 sm-mb-30px order-2 order-md-1">
                        <h3 class="text-white fw-500 alt-font mb-50px ls-minus-1px sm-mb-30px">Let’s turn opportunity into achievement.</h3>
                        <div class="row">
                            <div class="col-lg-5 col-6">
                                <span class="alt-font fs-14 text-uppercase d-block text-white ls-1px lh-24 fw-600">Call  Us</span>
                                <a class="text-white" href="tel:+918590998697">+91 8590998697</a>
                            </div>
                            <div class="col-lg-5 col-6">
                                <span class="alt-font fs-14 text-uppercase d-block text-white ls-1px lh-24 fw-600">Send a message</span>
                                <a href="mailto:info@brands.com" class="text-white"><span class="__cf_email__" data-cfemail="224b4c444d62464d4f434b4c0c414d4f">info@brands.com</span></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2 offset-lg-1 col-6 order-3 order-md-2">
                        <span class="alt-font fs-24 text-uppercase mb-5px d-block text-white ls-1px fw-600">Quick Links</span>
                        <ul >
                            <li><a href="#" class="text-white">Home</a></li>
                            <li><a href="#" class="text-white">About Us</a></li>
                            <!-- <li><a href="#" class="text-white">Services</a></li> -->
                            <!-- <li><a href="#" class="text-white">Portfolio</a></li> -->
                            <li><a href="#" class="text-white">Contact</a></li>
                        </ul>
                    </div>
                    <div class="col-md-2 col-6 order-3 order-md-3">
                        <span class="alt-font fs-24 text-uppercase mb-5px d-block text-white ls-1px fw-600">Follow Us</span>
                        <ul>
                            <li><a href="https://www.pinterest.com/" target="_blank" class="text-white">Pinterest</a></li>
                            <li><a href="https://www.twitter.com" target="_blank" class="text-white">Twitter</a></li>
                            <li><a href="http://www.dribbble.com" target="_blank" class="text-white">Dribbble</a></li> 
                            <li><a href="https://www.instagram.com" target="_blank" class="text-white">Instagram</a></li>
                            <li><a href="http://www.behance.com" target="_blank" class="text-white">Behance</a></li>
                        </ul>
                    </div>
                    <div class="col-md-2 order-1 order-md-4 sm-mb-30px">
                        <a href="#" class="footer-logo"><img src="images/logo.png" data-at2x="images/logo.png" alt="" style="width:200px"></a>
                    </div>
                </div>
                <div class="row">
                    
                    <div class="col-md-7 text-md-end sm-mt-15px last-paragraph-no-margin">
                        <p class="fs-13 lh-22 text-white">&copy; 2025 <a href="./" class="text-white">Brands Always</a> is Design by <a href="https://neowebtec.com/" target="_blank" class="text-decoration-line-bottom text-white">Neoweb Technologies</a></p>
                    </div>
                </div>
            </div>
        </footer>
        <!-- end footer -->
         <!-- start scroll progress -->
        <div class="scroll-progress d-none d-xxl-block">
          <a href="#" class="scroll-top" aria-label="scroll">
            <span class="scroll-text">Scroll</span><span class="scroll-line"><span class="scroll-point"></span></span>
          </a>
        </div>
        <!-- end scroll progress -->
        <!-- javascript libraries -->
        <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script type="text/javascript" src="js/jquery.js"></script>
        <script type="text/javascript" src="js/vendors.min.js"></script>
        <script type="text/javascript" src="js/main.js"></script>
    </body>
</html>